package provide VBox 1.2
######################################################################
####
####  VMDMagazine
####
####  Visualize different states of VMD in a simple and easy way
####
#### Developer: (c) 2014 Nuno Sousa Cerqueira
#### e-mail :   nscerque@fc.up.pt
####
#### version 1.0
####
######################################################################


#### INIT ############################################################


namespace eval ::VBox:: {
    namespace export vBox

	variable version		"1.2"
	variable directory		$VBox_directory;        # directory where the examples are located
    variable namdPath       $VBox_namd;             # directory of the namd executable
    variable topGui			".vbox";                # gui name
    variable loop			0  ;                    # variable that controls if the loop in the animation is enable or not
    variable timeChange		5 ;                    #time required to jump to the next example (secounds)
    variable timeInit		[clock format [clock seconds] -format %T]; #time to initiate the process
    variable timeAdd        0; # add time if necessary
    variable afterID		0;                      # identification of the process that controls the subtitles roll
    variable playID         0;
    variable file_Name		"";                     # name of the example
	variable screenloopdelay	25;                     # screen delay time to control subtotles speed
	variable animloopDelay		1;                      # time o slowdown or accelerate roll,rock and translate animations (CPU dependent) 
    variable animationPlay		0;                      # varibale that controls if the animations are played or not
	variable language		"English";		# default language
	variable status			"Stop";                  # variable that controls the roll animation
	variable viewpoints		0;			# variable for viewpoints
	variable create_viewpoint	0;			# variable for viewpoints
    variable treeItems {}
    variable step			1;                      # variables for the subtitles
    variable delay			25
    variable stop			0
    variable smallest		75
    variable cnt			0
    variable tracking 0
    variable diff 0
    variable steps 0 ;#roll
    variable i 0     ;#roll
    variable t 0     ;#roll
    variable times 0 ;#roll
    variable treeSelect 0
    variable treeID {}
    variable countID 0
    variable lastitem ""       ;# know the last item when the movie is selected
    variable lastitemStatus 0   ;# to control if the last item that was selected
    variable itemLogo       ""      ;# logo of the example
    variable itemcolor      black   ;# color fo the logo
    variable moviePlay      0; # see ig there is is movie /simulation 
	variable pickedAtoms ""
	variable graphicsID "" ;# graphics that are generated in bonds, angle and dihedral

variable top {
    R0lGODdhbwAxAOYAAAAAAAQLAwgNAgETCwcTBgoTAwwaBgUbCgkdCQ4hBQUiDAwkCxAmBxAnCw0r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}


variable top1 {
R0lGODlhwQA0ANUAAAAAAAgGAAwJABEOABQQABkUAB0YACMdACcgACskADMqADguADwyAEI2AEU5\
AEk9AE5AAFJEAFdIAFtLAGNTAGhWAGtZAHBdAHRgAHplAH5pAINtAIdwAIpzAJN6AJh+AJyCAKCF\
AKWJAKqNAK6RALOVALaYALubAMSjAMinAMupANCtANWxANq1AN65AOK8AObAAOvEAPPLAPjPAP7U\
AP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAADYALAAAAADBADQAAAb/QJtw\
SCwaj8ikcslsOp/QqHRKrVqv2Kx2y+16v+CweEwum8WAtHrNbrvf8Lh8Tq/b73h7Ns/v+/+AgX57\
goWGh4iJaYSKjY6PkACMkZSVlnpYl5qbnIuZnaChjZMYG6YdHRRsDyAhIiIjIwgACqeoHg5tCrAj\
JCUlqgAJth0eHh0YEQmizHOTJzTR0SxsHtLSAgAT19EobSHcNB5pEeHcKBHN6m2TGeFsKNwpadvh\
y2oBMuHjAOXm3CPWCZT0KY2CcArWxODWgZ65hmr8ceMn8Z80EgPVTQKg79oENQTCPUgjwdyLNSTM\
gUgDwWI4CxmZbSzBUA2DcNn6/RsJYMAM/5VpHnCT4QHFT24wAsQMtREDtxNqKnBTEfFfQAAU/q0E\
IPTayZ4rXi4FtfHgNRhqrF3jp9PcjAEAoJkLkcYBt68ACiy8VmJsp40A9kojkEautHQsLVooYFFE\
mgbcYqxRK02GHAEUTrxg0AauXz6AaV5rkOYFN8JBAUpT4TQaCG6OAUC+JlnN7Gv32CQQkEEwVTUG\
aAZLe0LpZziAL3C7AEAAN2pqukrLoEKa6Wh2r129SXuNc26IQXrQIHgwy7190wyIRyPDceQF1STg\
tnLBxDXZpXHYEO4FAoBpcCdNbWp0JM1wzbFwjQwbHKCCZVhdA5MwLUhTwXtvABbYNVRl5f/RGrdF\
44FZ13ww3zUYAWDfgmxUeI17VUkTQgGlBSTVMTTEkE0DBrLFiQAH/KHhCCx2wA2NtnFDl4vSOEBi\
NOk9SQOEajAZzQaTdZNQgDQwUA5zItDAXARH0WBCKAe8QCBo8alhATcHmHCNC2wICCUA/A0IgJ00\
RDkUG+XRgCAIKHy0BgopLCCDe/Od1BILWbXgWSdGXtWHhice5sI1W9n0lDCcApDfnbRwMwMb4eQS\
R0sWxMAPNBM8MMMJacqQGxsHRIBaG7vBkeuuciigQU6XtqlGeUZeg6CKU6VRXTQjSRcNVKBy4509\
cQjwQgsreKMNDSjwWIIA8YS3xgPspaf/hgAb6DPhKumqcQBECiCZhgFbumHArQqA0IK6nlzxBpHW\
wcmGlNApl2Ni11CbqTTn4hSHNTK8QNgAC1kgw5kf0EAXrobRAMG5e4EggL0AHBDyyLQs5OLHALzm\
LQABWCBBGk7NkwZ/KCwErIYR/oOXGginwRgNW0lLg8PvqPFad3AIyBkARKYQQ3FZyYCyqOi9+W6e\
KSRUAoEOdE3DhJtes0IayQ4XTwcCiEZVAMIJEMOZawB9QGO6cNOCGtCQxtWn1V4DUqA+sjHAdVgG\
TcMKJ+vTuBoeoqDA4jSo2nYaRKZX+eWmqXqCCh5c0K57JZmZlpkDpBDNDAmFCdPoWwMN/8B14Sxb\
eDR/00P2OWnsbW1zrnNjABwEe3tARy/Q+JqOEZ9dGA0pCjUDy5t3NSE0Ka6XTQcscBbAQijkBBkL\
BfT8miqQtbAACiEQq4btYZpzaxoP00BnGgJAJCrwKQtHBDpgpWjArA0ekkGQAPAsW1WrUz1xnaE6\
JgPUxIM5AHCKDGIQAAFIMA0URI0IGGAA+OWkHC+YFDQcUIIWJAAGH7NGDEaQG/nZzkORcUP+9se/\
JF1DeS7hxv3k1REMauAwaVDYzViCAhecJG4uSIHOKBADGXyPBhyYgQYS0MQnliCKU6QhDF5wPKyk\
hB8EOAEMwAWDA/BnNyDYFAbWAIKpBf/MCr4yh6XWkL+hrYFPOjNAEKUxuTZIBVxqWGN71FC/ZRBA\
BCwITgwasAIYJEAGM/BACkrwmgtcsF0aUMEBxkZJS2JSk315gD5aIAAQbGA+MbBAB2LAAfYwQAD6\
CIELNiAnvDFgBXPMm7HWgDtpvGsNwrPOG/j0m6MFMXG6ocEMcqMPgMnlBB64GlzqEYMEkKgEAehK\
DCBgN+plg5velAY41VOdFiCmRwAwEnNuM0eFvWCNMBKmwOAADm7kC5lIWWaz8hLEF7AsDiFA0AlY\
IL83TWcNIUBBkE7kvwpggEZOKWREJxoN/7GtS27K0YQIEIwCzCAGiDGAIl1grvkNUw3TE4hBDMb4\
Aui0wQAzkIFOY9A7XrFgBSpQQQo+RoCc7lSmLMCmqvJQAGA1pwMvIMEQ8bNANngtDg6oanPAYdMe\
vmEAxlEPBOzIjpdiSBPWmBkdDtCCELBAA46w3VkrYY1p2iEBMciAA1IYV7PONRKHxCAdBNACDRQg\
fI+Q618dQYBc3gEDUmXBMRWh2MUqwh3rtAMJdNpSyvrVsoooRR4uIIKpJqKyoE0tm/ap2tYKArWu\
jW0cYCvb2rKBtrbN7Rl2y9ve+va3wA2ucIdL3OIaFwpBAAA7	
}

variable tiled {R0lGODlhyADIAPcAACIkJSEkJSEkJCEjJCAjJCAjIyAiIx8iIx8iIh8hIh4h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}

variable photo {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}

variable message "
			-font {Helvetica 16 bold}
			-fill #37cf11
			VMD Magazine v$VBox::version

			-font {Helvetica 14}
			-fill #f58e14
			Nuno M. F. Sousa A. Cerqueira
                        Pedro A. Fernandes
                        Maria Joao Ramos

			-fill white
			-font {Helvetica 12}
				(c) 2017
				Grupo de Quimica e Bioquimica Teorica e Computacional

			        Faculdade de Ciencias

				Universidade do Porto

                Contact: nscerque@fc.up.pt
 	"


}


#### GUI ############################################################

proc VBox::startGui {} {

	#### Check if the window exists
	if {[winfo exists $::VBox::topGui]} {wm deiconify $::VBox::topGui ;return $::VBox::topGui}
	toplevel $::VBox::topGui

	#### Title of the windows
	wm title $VBox::topGui "VMD Magazine v$VBox::version " ;# titulo da pagina

	#### Change the location of window
	# screen width and height
	set sWidth [expr [winfo vrootwidth  $::VBox::topGui] -0]
	set sHeight [expr [winfo vrootheight $::VBox::topGui] -50]

	#window wifth and height
	set wWidth [winfo reqwidth $::VBox::topGui]
	set wHeight [winfo reqheight $::VBox::topGui]
	
	display reposition 0 [expr ${sHeight} - 15]
	display resize [expr $sWidth - 400] ${sHeight}

	#wm geometry window $VBox::topGui 400x59 0
	set x [expr $sWidth - 2*($wWidth)]

	wm geometry $::VBox::topGui 400x${sHeight}+$x+25


        #### FRAME 0
        grid [frame $VBox::topGui.frame0 -bg black] -row 0 -column 0 -padx 1 -pady 1 -sticky ew

        image create photo imgtop1 -data $VBox::top1
        grid [canvas $VBox::topGui.frame0.c -height 48 -bg black -width 170 -highlightthickness 0] -in $VBox::topGui.frame0 -row 0 -column 0 -sticky w
        $VBox::topGui.frame0.c create image 100 22 -image imgtop1
 

        #image create photo imgtop -data $VBox::top
        #grid [canvas $VBox::topGui.frame0.c1 -height 40 -bg black -width 110 -highlightthickness 0] -in $VBox::topGui.frame0 -row 0 -column 1 -sticky e
        #$VBox::topGui.frame0.c1 create image 55 20 -image imgtop


	#### FRAME 1 - Paned Window
	grid [ttk::panedwindow $VBox::topGui.frame1  -orient vertical] -row 1 -column 0 -padx 1 -pady 1 -sticky news

		#treeView
		$VBox::topGui.frame1 add [ttk::frame $VBox::topGui.frame1.f]

          ## add trreview and scrool     
     	  grid [ttk::treeview  $VBox::topGui.frame1.f.tree -yscroll "$VBox::topGui.frame1.f.vsb set" -show tree] -in $VBox::topGui.frame1.f -row 0 -column 0 -sticky news
          grid [ttk::scrollbar $VBox::topGui.frame1.f.vsb -orient vertical -command "$VBox::topGui.frame1.f.tree yview"] -in $VBox::topGui.frame1.f -column 1 -row 0 -sticky ns 


		# Canvas
		$VBox::topGui.frame1 add [canvas $VBox::topGui.frame1.c1 -height 380 -bg black]


	#### FRAME 3
	grid [ttk::frame $VBox::topGui.frame3] -row 2 -column 0  -padx 15 -pady 5 -sticky ew

		# Button
		grid [ttk::button $VBox::topGui.frame3.bt1 -text "Options" -command "VBox::AboutGui"] -in $VBox::topGui.frame3 -row 1 -column 2 -sticky news
                grid [ttk::button $VBox::topGui.frame3.bt2 -text "Exit" -command {VBox::Exit}] -in $VBox::topGui.frame3 -row 1 -column 1 -sticky news


		# Toold



grid [ttk::menubutton $VBox::topGui.frame3.tools -text "Tools" -menu $VBox::topGui.frame3.tools.menu \
		-style molUP.menuBar.TMenubutton ] -in $VBox::topGui.frame3 -row 1 -column 3 -sticky news
		

		menu $VBox::topGui.frame3.tools.menu -tearoff 0
		$VBox::topGui.frame3.tools.menu add command -label "Reset view" -command {display resetview}
		$VBox::topGui.frame3.tools.menu add command -label "Center atom" -command {mouse mode center}
		$VBox::topGui.frame3.tools.menu add command -label "Bond, Angle, Dihedrals" -command {VBox::badParams}
		$VBox::topGui.frame3.tools.menu add command -label "Delete all labels" -command {molUP::deleteAllLabels}
		$VBox::topGui.frame3.tools.menu add command -label "Delete all graphics" -command {graphics 0 delete all}


	#### Add logo
	#bind $VBox::topGui.frame0 <Configure> {VBox::Recenter %W %h %w}
	#VBox::shadedtext $VBox::topGui.c 75 -20 white black  -font {Helvetica 32 bold} -text "VMD Magazine" -justify center -anchor c
	#VBox::shadedtext $VBox::topGui.c -25 8 grey black  -font {Helvetica 8 normal} -text " � 2013" -justify center -anchor c

	#### Background image
	image create photo foo -data $VBox::tiled
 	$VBox::topGui.frame1.c1 create image 0 0 -anchor nw -image [image create photo foo-tiled]
 	foo-tiled copy foo -to 0 0 [winfo width $VBox::topGui.frame1.c1] [winfo height $VBox::topGui.frame1.c1]


	#### Animation Rolling credits
	bind $VBox::topGui.frame1.c1 <Configure> {foo-tiled copy foo -to 0 0 [winfo width $VBox::topGui.frame1.c1] [winfo height $VBox::topGui.frame1.c1]}
	tkwait visibility $VBox::topGui.frame1.c1


	#### GUI weight
        grid rowconfigure        $VBox::topGui                  1 -weight 1
        grid columnconfigure     $VBox::topGui                  0 -weight 1

        grid columnconfigure     $VBox::topGui.frame0           1 -weight 1
        grid rowconfigure        $VBox::topGui.frame0           0 -weight 1

        grid rowconfigure        $VBox::topGui.frame1.f         0 -weight 1
        grid columnconfigure     $VBox::topGui.frame1.f         0 -weight 1

        grid rowconfigure        $VBox::topGui.frame1           0 -weight 1
        grid columnconfigure     $VBox::topGui.frame1           0 -weight 1

        grid columnconfigure     $VBox::topGui.frame3           0 -weight 1
        grid columnconfigure     $VBox::topGui.frame3.bt1       0 -weight 1



	#### Add button to Canvas
        VBox::Canvas_button_creation $VBox::topGui.frame1.c1 [expr [winfo width $VBox::topGui] - 60] 15 Translate oval
        VBox::Canvas_button_creation $VBox::topGui.frame1.c1 [expr [winfo width $VBox::topGui] - 105] 15 Zoom oval
        VBox::Canvas_button_creation $VBox::topGui.frame1.c1 [expr [winfo width $VBox::topGui] - 155] 15 Rotate oval




   	$VBox::topGui.frame1.c1 create text 10 18 -text "Movie:"  -font {Helvetival 9} -fill black  -anchor w  -tag movie

	VBox::Canvas_button_creation $VBox::topGui.frame1.c1 85 16 Animate polygon
	VBox::Canvas_button_creation $VBox::topGui.frame1.c1  45 15 Stop square

      	  ## reset buttons
      	  $VBox::topGui.frame1.c1 itemconfigure _Rotate-bt -fill #a90a09

       	 ## New comands
		$VBox::topGui.frame1.c1 bind _Rotate <ButtonRelease-1> "+VBox::Canvas_button_reset $VBox::topGui.frame1.c1 Rotate"
         $VBox::topGui.frame1.c1 bind _Rotate-bt <ButtonRelease-1> "+VBox::Canvas_button_reset $VBox::topGui.frame1.c1 Rotate"

		$VBox::topGui.frame1.c1 bind _Zoom <ButtonRelease-1> "+VBox::Canvas_button_reset $VBox::topGui.frame1.c1 Zoom"
		$VBox::topGui.frame1.c1 bind _Zoom-bt <ButtonRelease-1> "+VBox::Canvas_button_reset $VBox::topGui.frame1.c1 Zoom"

		$VBox::topGui.frame1.c1 bind _Translate <ButtonRelease-1> "+VBox::Canvas_button_reset $VBox::topGui.frame1.c1 Translate"
      	$VBox::topGui.frame1.c1 bind _Translate-bt <ButtonRelease-1> "+VBox::Canvas_button_reset $VBox::topGui.frame1.c1 Translate"








		$VBox::topGui.frame1.c1 bind _Animate <ButtonRelease-1> "+VBox::animPlay"
       	$VBox::topGui.frame1.c1 bind _Animate-bt <ButtonRelease-1> "+VBox::animPlay"

         $VBox::topGui.frame1.c1 bind _Stop <ButtonRelease-1> "+set VBox::loop 0; VBox::animPause 0"
         $VBox::topGui.frame1.c1 bind _Stop-bt <ButtonRelease-1> "+set VBox::loop 0; VBox::animPause 0"

}


#### Exit  ########################################################

proc VBox::Exit {} {
    set VBox::status "Stop"
    after cancel $VBox::afterID
    VBox::animPause 0
    wm withdraw $VBox::topGui
    if {[winfo exists $::VBox::topGui.about]} {wm withdraw $::VBox::topGui.about}

}

#### Animations ########################################################

proc VBox::animPlay {} { 

    #Path
    set path $::VBox::directory
    set item [lsearch $VBox::treeItems [lindex [$VBox::topGui.frame1.f.tree  selection] 0]]
    foreach a [lindex $VBox::treeItems $item] {set path "$path/$a"}

	# play the animation file
	cd $path

	if {[file exists $path/start.ani]==1} {

    $VBox::topGui.frame1.c1 itemconfigure _Animate-bt -fill green
    $VBox::topGui.frame1.c1 itemconfigure _Stop-bt -fill #a90a09

        set VBox::status "Run"
        set loadFile [open start.ani r]
        set VBox::playID $loadFile
        while {![eof $loadFile] && $VBox::status!="Stop" } {
          set cmd [gets $loadFile]
          eval $cmd
         }
         close $loadFile

        #play start.ani
        cd .. 
    }

}

proc VBox::animPause {opt} {
    #::vcr_gui::clearmlist
   	#::vcr_gui::new_viewpointlist
    #set ::VCR::stepsize 0
    #set VBox::tracking -1; update
    #set VBox::diff 0; update
    

    # stop simulations
    if {$VBox::moviePlay==1} {
        set VBox::moviePlay 0
        ## connect to any existant
            set rc [catch { imd connect [string trim $hostname] $port } msg]
            # Kill any available IMD
            set rc [catch { imd kill } msg]
            after 200
    }

     $VBox::topGui.frame1.c1 itemconfigure _Animate-bt -fill #07890b
     $VBox::topGui.frame1.c1 itemconfigure _Stop-bt -fill red
     $VBox::topGui.frame1.c1 itemconfigure movie -fill black  


    set VBox::status "Stop"; update
    set VBox::times 0
    set VBox::steps 0
	animate pause
	rock off
	mouse rocking off
	mouse mode 0
    display resetview
    display update ui
    if {$opt!="0"} {VBox::animPause [expr $opt-1]}

}

#### Animations Tools ##################################################

proc VBox::TranslateAxis {times vec deg {molid top}} {
          $VBox::topGui.frame1.c1 itemconfigure movie -text  Anim
          $VBox::topGui.frame1.c1 itemconfigure movie -fill magenta

        for {set t 0} {$t<$times} {incr t 1} {

                # get the current matrix
                lassign [molinfo $molid get rotate_matrix] curr
                # the transformation matrix
		set r [transaxis $vec [expr ($deg+0.0) / ($VBox::animloopDelay+0.0) ]]

		# get the new matrix
		set m [transmult $r $curr]

		# and apply it to the molecule
		molinfo $molid set rotate_matrix "{ $m }"
		if {$VBox::status=="Stop"} {break}
		display update ui
        }
}


proc VBox::RockAxis {axis degree} {
    $VBox::topGui.frame1.c1 itemconfigure movie -text  Anim
    $VBox::topGui.frame1.c1 itemconfigure movie -fill magenta
	set degree1 [expr ($degree+0.0) / ($VBox::animloopDelay+0.0)]
	rock $axis by $degree1

}


proc VBox::Roll {times steps yangle xangle} {
    $VBox::topGui.frame1.c1 itemconfigure movie -text Anim
    $VBox::topGui.frame1.c1 itemconfigure movie -fill magenta
	#set times   100; # number of times to animate the sequence
	#set steps   500; # number of frames per complete sequence
	#set yangle 15.0; # Y-axis arc angle to sweep over
	#set xangle 10.0; # X-axis arc angle to sweep over (yangle / 2.0 or so is good)

	VBox::Save_viewpoint;  # save original viewpoint
    set VBox::times $times
	set VBox::steps [expr ($steps+0.0) * ($VBox::animloopDelay+0.0)]
    for {set VBox::t 0} {$VBox::t<$VBox::times} {incr VBox::t } {
        if {$VBox::status=="Stop"} {break}
      for {set VBox::i 0} {$VBox::i<$VBox::steps} {incr VBox::i} {
            if {$VBox::status=="Stop"} {break}
			display resetview
			VBox::Restore_viewpoint; # restore original viewpoint

			# now tweak relative to that view orientation
			set pipcnt [expr 6.28 * ($VBox::i / ($VBox::steps * 1.0))]
			rotate x by [expr $xangle * sin($pipcnt * 2.0)]
			rotate y by [expr $yangle * sin($pipcnt)]
			display update ui
		}

	}
}

proc VBox::MoviePlay {} {
  set VBox::moviePlay 1
  $VBox::topGui.frame1.c1 itemconfigure movie -text Sim
  $VBox::topGui.frame1.c1 itemconfigure movie -fill cyan
  display update ui
}

proc VBox::Save_viewpoint {} {
	upvar VBox::viewpoints 0
	if [info exists VBox::viewpoints] {unset VBox::viewpoints}
	# get the current matricies
	foreach mol [molinfo list] {
		set VBox::viewpoints($mol) [molinfo $mol get { center_matrix rotate_matrix scale_matrix global_matrix }]
	}
}

proc VBox::Restore_viewpoint {} {
	upvar VBox::viewpoints 0
	foreach mol [molinfo list] {
		if [info exists VBox::viewpoints($mol)] {
		molinfo $mol set { center_matrix rotate_matrix scale_matrix global_matrix } $VBox::viewpoints($mol)
		}
	}
}


proc VBox::Movie {file time} {
    set VBox::status "Movie"


	# disable representation changes
 	::VCR::disableRepChanges 

    $VBox::topGui.frame1.c1 itemconfigure movie -text Movie
    $VBox::topGui.frame1.c1 itemconfigure movie -fill yellow



proc movetime_vpNew {start end runtime {forcewait 0} } {
   variable current_vp
   set ::VCR::abort 0
   if {($start != $end)} {
       variable tracking
      ::VCR::initialise_movevp $start $end
      if { ($::VCR::movenorm < 0.05) && ($forcewait == 0) && [llength $::VCR::move] == 5 } {
            ::VCR::delrepchanges
            if { $::VCR::repchanges == 1} {
                ::VCR::restore_molrepstate $end
            }
            return
      }
      set t [time { ::VCR::retrieve_vp $start }]
      set t2 [time {set runtime [expr $runtime*1000000]}]
      set t2 [expr [lindex [split $t2] 0]+0.0]
      set Ttot $runtime
      set tracking 1.0
      set j 1
      set spf 0.0
      while { $tracking > 0 && $::VCR::abort == 0  && $VBox::status!="Stop"} {
            set t [expr [lindex [split $t] 0] + $t2*10]
            set runtime [expr 0.0 + $runtime - $t]
            set spf [expr ($spf*($j-1)+$t)/$j]  
            set ::VCR::stepsize [expr $tracking/$runtime*$spf]
            set diff [expr $tracking - $::VCR::stepsize]
            if { $diff < 0 || $::VCR::stepsize < 0} {
                set ::VCR::stepsize $tracking
                set tracking 0
            } else {
                set tracking $diff
            }
            incr j
            set t [time { ::VCR::move_vp_increment }]
            display update ui
       }
      if {$start == "here" || $end == "here"} {remove_vp "here"}
 
    } elseif { ($forcewait != 0 ) } {
         set t [time { ::VCR::restore_molrepstate $end } ]
         set t [expr [lindex [split $t] 0]] 
         set t [expr $runtime - ($t/1000000)]
         set ::VCR::stepsize [expr 100./($t*1000)]
         set tracking 1.0
         while { $tracking > 0 && $::VCR::abort == 0 } {
            #puts "VCR) Sleeping $t"
            after [expr int(100)]
            set tracking [expr $tracking-$::VCR::stepsize]
            display update ui
         }
    }

    ::VCR::delrepchanges
    set ::VCR::abort 0
    if { $::VCR::repchanges == 1} {
        ::VCR::restore_molrepstate $end
    }

}





	## clear movie list
	::vcr_gui::clearmlist
	::vcr_gui::new_viewpointlist


	## load vps points
        ::VCR::load_vps $file
        set ::vcr_gui::vplist [::VCR::list_vps]

	## Add All Viewpoints to Movie
      # ::vcr_gui::addalltomovie

	## dealing with time
        set ::vcr_gui::tempT $time
        ::vcr_gui::setnewtotaltime

	## Preview Movie
        set n [expr [llength $::VCR::movieList]-1]
        set i 0
        while { $i < $n && $VBox::status!="Stop"} { 
                set j [expr $i+1]
                set t [expr [lindex $::VCR::movieTimeList $i]*$::vcr_gui::timescale]
                if { $VBox::status!="Stop"} {::VCR::movetime_vp  [lindex $::VCR::movieList $i] [lindex $::VCR::movieList $j] $t}
             #   update; display update ui
                incr i
        }

	## clear movie list
	::vcr_gui::clearmlist


 $VBox::topGui.frame1.c1 itemconfigure movie -fill black
}

    





#### Canvas Button ######################################################

proc VBox::Canvas_button_creation {c x y text opt} {

	set r 8

	if {$opt=="oval"} {
		$c create oval $x $y [expr $x+$r] [expr $y+$r] -fill #07890b -tags [list _$text\-bt]
	}

	if {$opt=="polygon"} {
		$c create polygon $x $y $x [expr $y+$r] [expr ($x+$r)] [expr ($y+$r/2)] -fill  #07890b -tags [list _$text\-bt]
	}

	if {$opt=="square"} {
                $c create rectangle  $x $y [expr $x+$r] [expr $y+$r] -fill red -tags [list _$text\-bt]
        }

    if {$opt=="roll"} {
                $c create oval  $x $y [expr $x+$r] [expr $y+$r] -fill blue -tags [list _$text\-bt]
        }

	$c create text [expr $x+$r+5] [expr $y+$r/2.] -text $text  -font "Helvetival 8" -fill #07890b  -anchor w -tags [list _$text bt]

        ## Move o texto para cima e para baixo
               $c bind _$text <ButtonPress-1> [list $c move _$text  1 1]
               $c bind _$text <ButtonRelease-1>  [list $c move _$text -1 -1]

 }


proc VBox::Canvas_button_reset {c text} {
        $c itemconfigure _Zoom-bt -fill #07890b
        $c itemconfigure _Translate-bt -fill #07890b
        $c itemconfigure _Rotate-bt -fill #07890b
	   $c itemconfigure _Reset-bt -fill #07890b
        $c itemconfigure _$text\-bt -fill #a90a09

	   $c itemconfigure _Bond-bt -fill #07890b
	   

        switch $text {
            Zoom
              {mouse mode 2}
            Rotate
              {mouse mode 0}
            Scale
              {mouse mode 3}
            default
              {mouse mode 1}
        }

}



proc VBox::titleshow'roll  {w y tag dy} {
        $w move $tag 0 [expr $dy/4]
        foreach i [$w find withtag $tag] {
                set y1 [lindex [$w bbox $i] end]
		
		## when the text stop showing in the yy
                if {$y1<50} {$w move $i 0 $y}
        }
        llength [$w find withtag $tag]
	return
}


#### Language ############################################################

proc VBox::language {{what ""}} {
	set list {
		aa Afar ab Abkhazian af Afrikaans am Amharic ar Arabic as Assamese
		ay Aymara az Azerbaijani ba Bashkir be Byelorussian bg Bulgarian
		bh Bihari bi Bislama bn Bengali bo Tibetan br Breton ca Catalan
		co Corsican cs Czech cy Welsh da Danish de German dz Bhutani
		el Greek en English eo Esperanto es Spanish et Estonian eu Basque
		fi Finnish fj Fiji fo Faroese fr French fy Frisian ga Irish
		gl Galician gn Guarani gu Gujarati ha Hausa hi Hindi hr Croatian
		hu Hungarian hy Armenian ia Interlingua ie Interlingue ik Inupiak
		in Indonesian is Icelandic it Italian iw Hebrew ja Japanese ji Yiddish
		jv Javanese ka Georgian kk Kazakh kl Greenlandic km Cambodian
		kn Kannada ko Korean ks Kashmiri ku Kurdish ky Kirghiz la Latin
		ln Lingala lo Laothian lt Lithuanian lv Latvian mg Malagasy mi Maori
		mk Macedonian ml Malayalam mn Mongolian mo Moldavian mr Marathi
		ms Malay mt Maltese my Burmese na Nauru ne Nepali nl Dutch no Norwegian
		oc Occitan om Afan(Oromo) or Oriya pa Punjabi pl Polish ps Pashto
		pt Portuguese qu Quechua rm Rhaeto-romance rn Kurundi ro Romanian
		ru Russian rw Kinyarwanda sa Sanskrit sd Sindhi sg Sangho
		sh Serbo-croatian si Singhalese sk Slovak sl Slovenian sm Samoan
		sn Shona so Somali sq Albanian sr Serbian ss Siswati st Sesotho
		su Sundanese sv Swedish sw Swahili ta Tamil te Telugu tg Tajik th Thai
		ti Tigrinya tk Turkmen tl Tagalog tn Setswana to Tonga tr Turkish
		ts Tsonga tt Tatar tw Twi uk Ukrainian ur Urdu uz Uzbek vi Vietnamese
		vo Volapuk wo Wolof xh Xhosa yo Yoruba zh Chinese zu Zulu
	}

	if {$what==""} {
		foreach {short long} $list {lappend res $long}
		return [lsort $res]
	}

	set i [lsearch -exact $list $what]
	if {$i==-1} {return "--"}
	if {$i%2} {return [lindex $list [expr $i-1]]}

	return [lindex $list [expr $i+1]]
 }


#### Title Logo ############################################################

proc VBox::Recenter {W h w} {
	set h [expr {$h / 2.0}] ; set w [expr {$w / 2.0}]
	$W config -scrollregion [list -$w -$h $w $h]
}



proc VBox::shadedtext {w x y fg bg args} {
	eval [list $w create text $x $y -fill $bg] $args
	eval [list $w create text [incr x -1] [incr y -1] -fill $fg] $args
}

proc VBox::titleshow {w title} {

	## wrap the text based on screen size
	set width_W [winfo width $VBox::topGui]

	## search for the most lenghty sentence and which font it involves
	set maxWidth ""
	set maxWidthFont ""

	set -font "Helvetica 14 normal"
	set -fill "white"

	foreach lineX [split $title \n] {
                set lineX [string trim $lineX]
                if {[string match -* $lineX]} {
			eval [linsert $lineX 0 set]
		} else {
			if {$lineX!=""} {
			set textWidth [font measure ${-font} $lineX]
   			if { $textWidth > $maxWidth } {set maxWidth $textWidth ; set maxWidthFont ${-font} }
			}
		}
	}

	## Cut the text based on the windows width

	set a 0; set text "0"
	for {set a 0} {$a<$width_W} {incr a} {
		set text "$text\X"
		if {[font measure $maxWidthFont $text]>=$width_W} {break}
	}

	set title [VBox::wordwrap $a $title]

	## Prints the text

	set -fill white
	set -font {Helvetica 16}
	set x [expr {[winfo width $w]/2}]
	set y [winfo height $w]

	foreach line [split $title \n] {
		set line [string trim $line]
		if [string match -* $line] {
			eval [linsert $line 0 set]
		} else {
			$w create text $x $y -text $line -fill ${-fill} -font ${-font} -justify center -tag title
			incr y 24; #space between lines
		}
	}

        VBox::every [expr int($VBox::screenloopdelay)]  [list VBox::titleshow'roll $w $y title -2 ]
}


#### Loop ############################################################

proc VBox::loop {} {

    if {[$VBox::topGui.frame1.c1 itemcget _Animate-bt -fill]!="green"} {

    ## current item
    set item [lsearch $VBox::treeItems [lindex [$VBox::topGui.frame1.f.tree  selection] 0]]
    ## select next item
    $VBox::topGui.frame1.f.tree selection set "{[lindex $VBox::treeItems [expr $item+1]]}"
    ## see selection
    $VBox::topGui.frame1.f.tree see "[lindex $VBox::treeItems  [expr $item+1]]"
 }

}


#### Title Scrool ############################################################

proc VBox::every {ms body} {
	eval $body
	set VBox::afterID [after $ms [info level 0] ]

	## Loop
	set elaspetime [expr {( [clock scan [clock format [clock seconds] -format %T]] - [clock scan "$VBox::timeInit"]) / 1}]
        if {[expr $elaspetime - $VBox::timeAdd]>= $VBox::timeChange && $VBox::loop==1 } {VBox::loop}
	return
}


#### Choose Directory #########################################################
proc VBox::chooseDirectory {} {

	set fileExist 0
	set outputDirName [tk_chooseDirectory]
	set VBox::directory $outputDirName

    # Clean table
    $VBox::topGui.frame1.f.tree delete [$VBox::topGui.frame1.f.tree children {}] 
    
	# prints a message
	$VBox::topGui.frame1.c1 delete title
	VBox::shadedtext $VBox::topGui.frame1.c1 190 100 white black  -font {Helvetica 14 bold} -text "Source directory Changed..." -tag legend -justify center -anchor c; update
	VBox::shadedtext $VBox::topGui.frame1.c1 190 150 #f58e14 black  -font {Helvetica 10 bold} -text "( $::VBox::directory )" -tag legend -justify center -anchor c; update

        ## Add values
        VBox::treeAdd
    
        ## Select first value
        ## gets list of item from tree
            VBox::getitems $VBox::topGui.frame1.f.tree 0
        
        ## Select first value
            $VBox::topGui.frame1.f.tree selection set "{[lindex $VBox::treeItems 0]}"

}

#### About ############################################################

proc VBox::AboutGui {} {

	#### Check if the window exists
	if {[winfo exists $::VBox::topGui.about]} {wm deiconify $::VBox::topGui.about ; raise $::VBox::topGui.about; return}
	toplevel $::VBox::topGui.about

	#### Title of the windows
	wm title $VBox::topGui.about "VMD Magazine Options" ;# titulo da pagina
	wm geometry $::VBox::topGui.about 450x600+50+50
        wm resizable $::VBox::topGui.about 0 0 

      #### FRAME 0

       #### FRAME 1 - Canvas
       grid [ttk::frame $VBox::topGui.about.f1] -row 1 -column 0 -padx 1 -pady 1 -sticky news
	   image create photo imgphoto -data $VBox::photo
       grid [canvas $VBox::topGui.about.f1.c -bg black] -in $VBox::topGui.about.f1  -row 1 -column 0 -padx 1 -pady 1 -sticky news
	   $VBox::topGui.about.f1.c create image 220 172 -image imgphoto

        #### FRAME 2
        grid [frame $VBox::topGui.about.f2] -row 2 -column 0  -padx 15 -pady 5 -sticky ew

		# Time:checkbutton
		grid [ttk::checkbutton $VBox::topGui.about.f2.cb1 -text "Loop Animations (on/off)." -variable VBox::loop -offvalue 0 -onvalue 1  \
		  -command {if {$VBox::loop==1} {set VBox::animationPlay 1; $VBox::topGui.frame1.c1 itemconfigure movie -fill green -text Loop}}]\
		  -in $VBox::topGui.about.f2 -row 1 -column 0 -sticky ew

		# Time: spinbox
	#	grid [spinbox $VBox::topGui.about.f2.sb1 -from 1 -to 100000 -width 5 -textvariable VBox::timeChange ] -in $VBox::topGui.about.f2 -row 1 -column 1 -sticky ew

		## state of spinboxTime
    #	if {$VBox::loop==0} {$::VBox::topGui.about.f2.sb1  configure -state disable }

	        # Time: text
    #           grid [ttk::label $VBox::topGui.about.f2.t1 -text "(seconds)"] -in $VBox::topGui.about.f2 -row 1 -column 2 -sticky ew

        #### FRAME 3
        grid [ttk::frame $VBox::topGui.about.f6] -row 3 -column 0  -padx 15 -pady 5 -sticky ew

        # MouseflyOption:checkbutton
        grid [ttk::checkbutton $VBox::topGui.about.f6.cb1 -text "Play Animations when selected (on/off)." -variable VBox::animationPlay -offvalue 0 -onvalue 1 ]\
          -in $VBox::topGui.about.f6 -row 6 -column 0 -sticky ew

	#### FRAME 4
	grid [ttk::frame $VBox::topGui.about.f3] -row 4 -column 0  -padx 15 -pady 5 -sticky ew

		# directory choose
		grid [ttk::label $VBox::topGui.about.f3.t2 -text "Files Source Directory :" ] -in $VBox::topGui.about.f3 -row 0 -column 0 -sticky ew

		# directory entry
		 grid [ttk::entry $VBox::topGui.about.f3.en2 -textvariable VBox::directory]  -in $VBox::topGui.about.f3 -row 0 -column 1 -sticky ew

		#directory button
		grid [ttk::button $VBox::topGui.about.f3.b1 -text "Choose" -command {VBox::chooseDirectory} ] -in $VBox::topGui.about.f3 -row 0 -column 2 -sticky ew



    #### FRAME 5
        
	grid [ttk::frame $VBox::topGui.about.f31] -row 5 -column 0  -padx 15 -pady 5 -sticky ew

		# directory choose
		grid [ttk::label $VBox::topGui.about.f31.t2 -text "NAMD executable directory :" ] -in $VBox::topGui.about.f31 -row 0 -column 0 -sticky ew

		# directory entry
		 grid [ttk::entry $VBox::topGui.about.f31.en2 -textvariable VBox::namdPath]  -in $VBox::topGui.about.f31 -row 0 -column 1 -sticky ew

		#directory button
		grid [ttk::button $VBox::topGui.about.f31.b1 -text "Choose" -command {set VBox::namdPath [tk_getOpenFile]}] -in $VBox::topGui.about.f31 -row 0 -column 2 -sticky ew


	#### FRAME 6
                grid [ttk::frame $VBox::topGui.about.f5] -row 6 -column 0  -padx 15 -pady 5 -sticky ew

                # Scrool Text Speed
                grid [ttk::label $VBox::topGui.about.f5.t1 -text "Subtitle Language: " ] -in $VBox::topGui.about.f5 -row 0 -column 1 -sticky ew

                # directory entry
                 grid [ttk::combobox $VBox::topGui.about.f5.cb -values [VBox::language] -textvariable VBox::language] -in $VBox::topGui.about.f5 -row 0 -column 2 -sticky ew

	#### FRAME 7
        grid [ttk::frame $VBox::topGui.about.f4] -row 7 -column 0  -padx 15 -pady 5 -sticky ew

		# Scrool Text Speed
                grid [ttk::label $VBox::topGui.about.f4.t1 -text "Scrool Text Speed (ms): " ] -in $VBox::topGui.about.f4 -row 0 -column 0 -sticky ew

                # directory entry
                 grid [ttk::scale $VBox::topGui.about.f4.en1 -length 200 -from 1 -to 200  -variable VBox::screenloopdelay -command {VBox::legendupdate}] -in $VBox::topGui.about.f4 -row 0 -column 1 -sticky ew

		# apply label
                grid [ttk::label $VBox::topGui.about.f4.l2 -textvariable VBox::screenloopdelay] -in $VBox::topGui.about.f4 -row 0 -column 2 -sticky ew

        #### FRAME 8
        grid [ttk::frame $VBox::topGui.about.f7] -row 8 -column 0  -padx 15 -pady 5 -sticky ew

                # Scrool Text Speed
                grid [ttk::button $VBox::topGui.about.f7.bt -text "More information" -command {VBox::launchBrowser "http://www.fc.up.pt/PortoBioComp/database/doku.php?id=vmdmagazine"}] -in $VBox::topGui.about.f7 -row 0 -column 0 -sticky ew



	#### GUI weight
        grid rowconfigure        $VBox::topGui.about              1 -weight 1
	    grid columnconfigure     $VBox::topGui.about              0 -weight 1
        grid rowconfigure        $VBox::topGui.about.f1           1 -weight 1
        grid columnconfigure     $VBox::topGui.about.f1           0 -weight 1
        grid columnconfigure     $VBox::topGui.about.f7           0 -weight 1

	#### Image on About
        VBox::shadedtext $VBox::topGui.about.f1.c 140 335 white black  -font {Helvetica 10 normal} -text "v$VBox::version" -justify left -anchor c       
	update
}


#### Update Legend Speed ####################################################

proc VBox::legendupdate {a} {
	       set VBox::screenloopdelay  [expr int ($a)]
               after cancel $VBox::afterID
               $VBox::topGui.frame1.c1 delete withag title       
               VBox::titleshow $VBox::topGui.frame1.c1 $VBox::message
               update
}


#### Tiled Image ############################################################

proc VBox::tileGui {canvas args} {

                set oldImage [$canvas itemcget tile -image]
                switch -exact [llength $args] {
                        0 {set image $oldImage}
                        1 {set image [lindex $args 0]}
                        default {
                                return -code error "usage: tile path ?image?"
                        }
                }

                if {$image != $oldImage
                    || [string length $image] == 0} {
                        $canvas delete all
                }

                if {[string length $image] == 0} return

                set imageHeight [image height $image]
                set imageWidth [image width $image]

                set width [winfo width $canvas]
                set height [winfo height $canvas]

                set x 0
                while {$x < $width} {
                        set y 0
                        while {$y < $height} {
                                # see if there's already a tile here
                                set tags [$canvas gettags $x/$y]
                                if {$tags == ""} {
                                        $canvas create image $x $y \
                                            -image $image \
                                            -anchor nw \
                                            -tags [list VBox::tileGui $x/$y] \
                                    }
                                incr y $imageHeight
                        }
                        incr x $imageWidth
                }

        }


proc VBox::wordwrap {max msg} {
    if { [string length $msg] > $max } {
        regsub -all -line "(.{1,$max})( +|$|\n)" $msg "\\1\\3\n" msg
    }
    return $msg
}

#### Execute files ############################################################

proc VBox::cmd {path} {

    ## Stop custom animation
      VBox::animPause 0
	  $VBox::topGui.frame1.c1 delete title
	  after cancel $VBox::afterID
	  update

	## Stop mouseflynavigation if turned on 
        set mouseplay 0
	    if {$::NavFly::paws==0} {::NavFly::turn_off_flying; set mouseplay 1} 

	## Clean the VMD interface
		mol delete all
		set debug 0

	## Reset time
 	    set VBox::timeInit [clock format [clock seconds] -format %T]
        set VBox::timeAdd 0

	## Read Text
		## ver se o ficheiro existe
		if {[file exists $path/start.[VBox::language $VBox::language]]==1} {
			set VBox::message ""

		    ## open start.language
			set loadFile [open "$path/start.[VBox::language $VBox::language]" r]
            set VBox::playID [pid $loadFile]
			set VBox::message [read $loadFile]
			close $loadFile
		} else {
			## if it does not exist try to show the english version
			if {[file exists $path/start.en]==1} {
				set debug 0
                set VBox::message ""
                
                ## open start.language

                set loadFile [open "$path/start.en" r]
                set VBox::message [read $loadFile]
                close $loadFile
		
			## else does not show text
			} else { set debug 1}
		}

	## Play script

		if {[file exists $path/start.vmd]==1} {

            $VBox::topGui.frame1.c1 delete withag legend
            VBox::shadedtext $VBox::topGui.frame1.c1 190 100 white black  -font {Helvetica 36 bold} -text "Loading..." -tag legend -justify center -anchor c; update
            VBox::shadedtext $VBox::topGui.frame1.c1 190 150 #f58e14 black  -font {Helvetica 16 bold} -text "(Please wait)" -tag legend -justify center -anchor c; update

            cd $path
            if {[file exists $path/start.vmd]==1} {play start.vmd; cd ..}

		} else {set debug [expr $debug +2]}

		## Add text to the GUI                
        $VBox::topGui.frame1.c1 delete withag legend; update
        if {$debug==1} {set VBox::message "-fill yellow \n  Description not available !" }
        if {$debug==2} {set VBox::message "-fill yellow \n  Structure not available ! \n \n $message" }
        if {$debug==3} {set VBox::message "-fill yellow \n  Description and structure not available !" }
        VBox::titleshow $VBox::topGui.frame1.c1 $VBox::message

        
	## Play Animation
        if {[file exists $path/start.ani]==1 && $VBox::animationPlay==1 } {VBox::animPlay}

        ## Turn on mouseflynavigation turned on if selected
        if {$mouseplay==1} {::NavFly::turn_on_flying}
        
        if {$VBox::moviePlay==0} {
            $VBox::topGui.frame1.c1 itemconfigure _Animate-bt -fill  #07890b
            $VBox::topGui.frame1.c1 itemconfigure _Stop-bt -fill red
        }

        display update ui


}


#### Launch Browser ######################################################

proc VBox::launchBrowser url {
      global tcl_platform

    # It *is* generally a mistake to switch on $tcl_platform(os), particularly
    # in comparison to $tcl_platform(platform).  For now, let's just regard it
    # as a stylistic variation subject to debate.
      switch $tcl_platform(os) {
        Darwin {
          set command [list open $url]
        }
        HP-UX -
        Linux  -
        SunOS {
          foreach executable {firefox mozilla netscape iexplorer opera lynx
                       w3m links epiphany galeon konqueror mosaic amaya
                       browsex elinks} {
            set executable [auto_execok $executable]
            if [string length $executable] {
    # Do you want to mess with -remote?  How about other browsers?
    # Frank Darby says the '&' leads on his Ubuntu to attempts to
    # open 'www.&.com', and so on.
              set command [list $executable $url &]
              set command [list $executable $url]
              break
            }
          }
        }
        {Windows 95} -
        {Windows NT} {
          set command "[auto_execok start] {} [list $url]"
        }
      }
      if [info exists command] {
        # Replace {*}$command by eval "$command" if you want < tcl 8.5 compatibility ([RA])
        # Added the '&' to launch the browser as background process. [Duoas]
        if [catch {exec {*}$command &} err] {
          tk_messageBox -icon error -message "error '$err' with '$command'"
        }
      } else {
        tk_messageBox -icon error -message \
          "Please tell CL that ($tcl_platform(os), $tcl_platform(platform)) is not yet ready for browsing."
      }
    }


#### Tree Browser ######################################################

# builds a flat list of files/directories one level under $path
proc  VBox::Tree-ls {path} {
        # catch permissions errors
        if {[catch {glob -nocomplain -tails -directory $path *} result]} {set result {} }
        return $result
}

# recursively builds a nested dict of all files/directories under $path
proc VBox::Tree-ls-R {path} {
        set result {}
        foreach item [VBox::Tree-ls $path] {
                if {[file isdirectory [file join $path $item]]} {
                        dict set result $item [VBox::Tree-ls-R [file join $path $item]]
                } else {
                #dict set result $item {}
                }
        }
return $result
}

# makes the filesystem tree
proc VBox::Tree-makeNestedDict {path} {
        return [VBox::Tree-ls-R $path]
}

#Here is the code to populate a ttk::treeview given a nested dict
# returns bool: is the element a leaf?
proc VBox::Tree-isLeaf element {
        return [expr {$element == {}}]
}




# fills given ttk::treeview $tree with contents of nested dict $dic
proc VBox::Tree-populateTreeView {tree parent dic id} {

        foreach {k v} $dic {
                set text [file rootname $k]

                if {$id=="ok"} {
                    incr VBox::countID

                    set treeID [$tree insert $parent end -id [list {*}$parent $k] -text $text -tag $VBox::countID]
                
                } else { $tree insert $parent end -id [list {*}$parent $k] -text $text }

                if {![VBox::Tree-isLeaf $v]} {VBox::Tree-populateTreeView $tree [list {*}$parent $k] $v ok}
        }
}





proc VBox::getitems {w run {item {}}} {
    if {$run==0} {set VBox::treeItems ""}
    foreach n [$w children $item] {
        set VBox::treeItems [lappend VBox::treeItems $n]
        VBox::getitems $w 1 $n
    }
}

proc VBox::treeAdd {} {
	set w $VBox::topGui.frame1.f.tree
	$VBox::topGui.frame1.f.tree configure -columns "items"
	$VBox::topGui.frame1.f.tree configure -height 20
	$VBox::topGui.frame1.f.tree column "items" -width 200 -anchor center
	set nestedDict [VBox::Tree-makeNestedDict $VBox::directory]
	VBox::Tree-populateTreeView $VBox::topGui.frame1.f.tree {} $nestedDict 0

    # color rows
    #$VBox::topGui.frame1.tree tag configure oddrow -background orange
    #$VBox::topGui.frame1.tree tag configure evenrow -background white


	bind $VBox::topGui.frame1.f.tree <<TreeviewSelect>> {

        if { [ $VBox::topGui.frame1.c1 itemcget _Animate-bt -fill]!="green"} {

            ## get item
            set path $::VBox::directory
            set item [lsearch $VBox::treeItems [lindex [$VBox::topGui.frame1.f.tree  selection] 0]]
            foreach a [lindex $VBox::treeItems $item] {set path "$path/$a"}

            ## set last item
            set VBox::lastitem $item

            ## Play File if it has the *.vmd and t is not Movie
            if {[file exists $path/start.vmd]==1} {VBox::cmd $path} 

        } 
        
        
        if {[$VBox::topGui.frame1.c1 itemcget _Animate-bt -fill]=="green"} {

            if {$VBox::lastitemStatus==0} {
                set VBox::lastitemStatus 1
                ## select last item
                $VBox::topGui.frame1.f.tree selection set "{[lindex $VBox::treeItems $VBox::lastitem]}"
                ## see selection
                $VBox::topGui.frame1.f.tree see "[lindex $VBox::treeItems $VBox::lastitem]"
            } else {set VBox::lastitemStatus 0}

        } 


    }

}



proc VBox::badParams {} {
	

	#### Check if the window exists
	if {[winfo exists $::VBox::topGui.badParams]} {wm deiconify $::VBox::topGui.badParams ; VBox::badPickAtom; return $::VBox::topGui.badParams}
	toplevel $::VBox::topGui.badParams
	wm attributes $::VBox::topGui.badParams -topmost yes

	#### Title of the window
	wm title $::VBox::topGui.badParams "Bond, Angle and Dihedral Parameters" ;# titulo da pagina

	#### Change the location of window
	# screen width and height
	#set sWidth [expr [winfo vrootwidth  $::VBox::topGui.badParams] -0]
	#set sHeight [expr [winfo vrootheight $::VBox::topGui.badParams] -50]

	#### Change the location of window
    #wm geometry $::VBox::topGui.badParams 400x160+[expr $sWidth - 400]+100
	#$::VBox::topGui.badParams configure -background {white}
	#wm resizable $::VBox::topGui.badParams 0 0

	

    #### GUI

		## Frame 0 - LABELS
		grid [ttk::frame $::VBox::topGui.badParams.frame0] -row 1 -column 0 -padx 1 -pady 1 -sticky news
		

			grid [ttk::label $::VBox::topGui.badParams.frame0.label0 -text "Click on Atoms of the VMD window to get Bond, Angle and \nDihedral parameters."] \
				-in $::VBox::topGui.badParams.frame0 \
				-row 0 -column 0
						

		## Frame 1  - BAD PARABETERS
		grid [ttk::frame $::VBox::topGui.badParams.frame1] -row 0 -column 0 -padx 1 -pady 1 -sticky news


			# LABELS
			
			foreach a "Param Atom Index Type Resid Value Units" column "0 1 2 3 4 5 6" {

			grid [ttk::label $::VBox::topGui.badParams.frame1.label_$a -text "$a"] \
				-in $::VBox::topGui.badParams.frame1 \
				-row 0 -column $column
						
			}
						
			# BAD PARAMETERS	
			
			foreach a "None Bond Angle Dihedral" row "1 2 3 4" {
				
				
				
				# label BOND ANGLE DIHEDRAL
				if {$a=="None"} {
				grid [ttk::label $::VBox::topGui.badParams.frame1.label_$a -text ""] \
					-in $::VBox::topGui.badParams.frame1 \
					-row $row -column 0
				} else {
				grid [ttk::label $::VBox::topGui.badParams.frame1.label_$a -text "$a"] \
									-in $::VBox::topGui.badParams.frame1 \
									-row $row -column 0
				}
				
				# entry Label 
				grid [ttk::label $::VBox::topGui.badParams.frame1.label1_$a -text $row] \
				-in $::VBox::topGui.badParams.frame1 \
				-row $row -column 1		
				
				# entry Index 
				grid [ttk::entry $::VBox::topGui.badParams.frame1.entryIndex_$a -width 5] \
					-in $::VBox::topGui.badParams.frame1 \
					-row $row -column 2

				# entry 1 - INDEX SELECTION
				grid [ttk::entry $::VBox::topGui.badParams.frame1.entryAtom_$a -width 5] \
					-in $::VBox::topGui.badParams.frame1 \
					-row $row -column 3	
					
					
				# entry 3 - INDEX SELECTION
				grid [ttk::entry $::VBox::topGui.badParams.frame1.entryResid_$a -width 5] \
					-in $::VBox::topGui.badParams.frame1 \
					-row $row -column 4	



				if {$row>=2} {
				
					# entry 2 DISTANCE, ANGLE, DIHEDRAL
					grid [ttk::entry $::VBox::topGui.badParams.frame1.entryValue_$a -width 10] \
						-in $::VBox::topGui.badParams.frame1 \
						-row $row -column 5	
		
		
					# Units
					if {$row==3 || $row==4} {set text "Degrees"
					} else {set text "Angstroms"}
					
					grid [ttk::label $::VBox::topGui.badParams.frame1.units_$a -text $text] \
					-in $::VBox::topGui.badParams.frame1 \
					-row $row -column 6 -sticky w
					
				}
				
			}
			
		## Frame 2 - Buttons
		grid [ttk::frame $::VBox::topGui.badParams.frame2] -row 2 -column 0 -padx 1 -pady 1 -sticky news
				
				grid [ttk::button $::VBox::topGui.badParams.frame2.button_1 -text "Exit" \
							-command {mouse mode rotate;trace vdelete ::vmd_pick_atom w VBox::atomPicked; wm withdraw $::VBox::topGui.badParams;
							    if {[winfo exists $::VBox::topGui.badParams]} {wm withdraw $::VBox::topGui.badParams}}] \
							-in $::VBox::topGui.badParams.frame2 \
							-row 0 -column 3
							
				grid [ttk::button $::VBox::topGui.badParams.frame2.button_2 -text "Assign Atoms" \
					-command {mouse mode pick}] \
					-in $::VBox::topGui.badParams.frame2 \
					-row 0 -column 1
											
											
				grid [ttk::button $::VBox::topGui.badParams.frame2.button_3 -text "Delete Data" \
					-command {VBox::deleteAll}] \
					-in $::VBox::topGui.badParams.frame2 \
					-row 0 -column 2
	
	
	
	label textthickness 2
	VBox::badPickAtom
				
}


proc VBox::badPickAtom {} {
	
		## Trace the variable to run a command each time a atom is picked
	    trace variable ::vmd_pick_atom w VBox::atomPicked
		
		## Activate atom pick
		mouse mode pick
}


proc VBox::deleteAll {} {
	
	
		$::VBox::topGui.badParams.frame1.entryIndex_None delete 0 end
		$::VBox::topGui.badParams.frame1.entryAtom_None delete 0 end
		$::VBox::topGui.badParams.frame1.entryResid_None delete 0 end
		
		$::VBox::topGui.badParams.frame1.entryIndex_Bond delete 0 end
		$::VBox::topGui.badParams.frame1.entryAtom_Bond delete 0 end
		$::VBox::topGui.badParams.frame1.entryResid_Bond delete 0 end
		$::VBox::topGui.badParams.frame1.entryValue_Bond delete 0 end
				 
		$::VBox::topGui.badParams.frame1.entryIndex_Angle delete 0 end
		$::VBox::topGui.badParams.frame1.entryAtom_Angle delete 0 end
		$::VBox::topGui.badParams.frame1.entryResid_Angle delete 0 end
		$::VBox::topGui.badParams.frame1.entryValue_Angle delete 0 end 
		
		$::VBox::topGui.badParams.frame1.entryIndex_Dihedral delete 0 end
		$::VBox::topGui.badParams.frame1.entryAtom_Dihedral delete 0 end
		$::VBox::topGui.badParams.frame1.entryResid_Dihedral delete 0 end
		$::VBox::topGui.badParams.frame1.entryValue_Dihedral delete 0 end
		
		
		# clean graphics
		foreach a $VBox::graphicsID {
			foreach b $a {
				graphics [molinfo top] delete $b
			}
		} 
		
		#delete labels
		
		label delete Atoms all 
		label delete Bonds all 
		label delete Angles all 
		label delete Dihedrals all 
				
		
		# delete data
		set VBox::graphicsID ""
		set VBox::pickedAtoms ""

	
}

proc VBox::atomPicked {args} {
	
	
	if {[lsearch $VBox::pickedAtoms $::vmd_pick_atom]==-1} {


		if {[llength $VBox::pickedAtoms]>=4 || [llength $VBox::pickedAtoms]==0} {
		
		
		#Delete Index Atom Resid Param Value Check
		VBox::deleteAll
	
		# Add the first atom	
		set VBox::pickedAtoms $::vmd_pick_atom
	
	
	} else {lappend VBox::pickedAtoms $::vmd_pick_atom}
	
	
	# Put Values in the correct place
	
	if {[llength $VBox::pickedAtoms]==1} {
		
		# First Atom
		$::VBox::topGui.badParams.frame1.entryIndex_None insert 0 "[lindex $VBox::pickedAtoms 0]"
		set sel [atomselect top "index [lindex $VBox::pickedAtoms 0]"] 
		$::VBox::topGui.badParams.frame1.entryAtom_None insert 0 "[$sel get name]"
		$::VBox::topGui.badParams.frame1.entryResid_None insert 0 "[$sel get resid]"	
		# Draw
			set mem [VBox::sphere [lindex $VBox::pickedAtoms 0] red]
		
		set VBox::graphicsID [lappend VBox::graphicsID "$mem"]

				


	} elseif {[llength $VBox::pickedAtoms]==2} {
		
		
		#BOND
		$::VBox::topGui.badParams.frame1.entryIndex_Bond insert 0 "[lindex $VBox::pickedAtoms 1]"
		set sel [atomselect top "index [lindex $VBox::pickedAtoms 1]"] 
		$::VBox::topGui.badParams.frame1.entryAtom_Bond insert 0 "[$sel get name]"
		$::VBox::topGui.badParams.frame1.entryResid_Bond insert 0 "[$sel get resid]"
	
		# Value
		set value [strictformat %7.2f [measure bond  "[lindex $VBox::pickedAtoms 0] [lindex $VBox::pickedAtoms 1]"] ]
		$::VBox::topGui.badParams.frame1.entryValue_Bond insert 0 "$value"
		label add Bonds [molinfo top]/[lindex $VBox::pickedAtoms 0] [molinfo top]/[lindex $VBox::pickedAtoms 1]


		# Draw
		set mem [VBox::sphere [lindex $VBox::pickedAtoms 1] white]
		set mem1 [VBox::line [lindex $VBox::pickedAtoms 0] [lindex $VBox::pickedAtoms 1] white]
		
		
		set VBox::graphicsID [lappend VBox::graphicsID "$mem $mem1"]

	

	} elseif {[llength $VBox::pickedAtoms]==3} {
		
		#ANGLE
		
		$::VBox::topGui.badParams.frame1.entryIndex_Angle insert 0 "[lindex $VBox::pickedAtoms 2]"
		
		set sel [atomselect top "index [lindex $VBox::pickedAtoms 2]"] 
		$::VBox::topGui.badParams.frame1.entryAtom_Angle insert 0 "[$sel get name]"
		$::VBox::topGui.badParams.frame1.entryResid_Angle insert 0 "[$sel get resid]"
		
		# Value
		set value [strictformat %7.2f [measure angle "[lindex $VBox::pickedAtoms 0] [lindex $VBox::pickedAtoms 1] [lindex $VBox::pickedAtoms 2]"] ]
		$::VBox::topGui.badParams.frame1.entryValue_Angle insert 0 "$value"
		
		label add Angles [molinfo top]/[lindex $VBox::pickedAtoms 0] [molinfo top]/[lindex $VBox::pickedAtoms 1] [molinfo top]/[lindex $VBox::pickedAtoms 2]

		
		# Draw
		
		set mem [VBox::sphere [lindex $VBox::pickedAtoms 2] yellow]
		set mem1 [VBox::triangle [lindex $VBox::pickedAtoms 0] [lindex $VBox::pickedAtoms 1] [lindex $VBox::pickedAtoms 2] yellow]
		
		
		set VBox::graphicsID [lappend VBox::graphicsID "$mem $mem1"]
		
	} elseif {[llength $VBox::pickedAtoms]==4} {
		
		#DIHEDRAL
		
		$::VBox::topGui.badParams.frame1.entryIndex_Dihedral insert 0 "[lindex $VBox::pickedAtoms 3]"
		
		set sel [atomselect top "index [lindex $VBox::pickedAtoms 3]"] 
		$::VBox::topGui.badParams.frame1.entryAtom_Dihedral insert 0 "[$sel get name]"
		$::VBox::topGui.badParams.frame1.entryResid_Dihedral insert 0 "[$sel get resid]"
	
	
		# value
		set value [strictformat %7.2f [measure dihed "[lindex $VBox::pickedAtoms 0] [lindex $VBox::pickedAtoms 1] [lindex $VBox::pickedAtoms 2] [lindex $VBox::pickedAtoms 3]"] ]
		$::VBox::topGui.badParams.frame1.entryValue_Dihedral insert 0 "$value"
		
		label add Dihedrals [molinfo top]/[lindex $VBox::pickedAtoms 0] [molinfo top]/[lindex $VBox::pickedAtoms 1] [molinfo top]/[lindex $VBox::pickedAtoms 2]  [molinfo top]/[lindex $VBox::pickedAtoms 3]
		
		# Draw
		set mem [VBox::sphere [lindex $VBox::pickedAtoms 3] cyan]
		set mem1 [VBox::triangle [lindex $VBox::pickedAtoms 1] [lindex $VBox::pickedAtoms 2] [lindex $VBox::pickedAtoms 3] cyan]
		set mem2 [VBox::cylinder [lindex $VBox::pickedAtoms 1] [lindex $VBox::pickedAtoms 2] cyan]
		
		
		set VBox::graphicsID [lappend VBox::graphicsID "$mem $mem1 $mem2"]
	}
	
	
	
	}
}



proc VBox::strictformat {fmt value} {
    set f [format $fmt $value]
    regexp {%(\d+)} $fmt -> maxwidth
    if {[string length $f] > $maxwidth} {
        return [string repeat * $maxwidth]
    } else {
        return $f
    }
}


proc VBox::checkInfo {} {
	
	
	
	
}


proc VBox::sphere {selection color} {	
	set coordinates [[atomselect top "index $selection"] get {x y z}]
	
	# Draw a circle around the coordinate
	draw color $color
	draw material Transparent
	set a [graphics [molinfo top] sphere "[lindex $coordinates 0] [lindex $coordinates 1] [lindex $coordinates 2]" radius 0.5 resolution 25]
	
	return  $a
	
}


proc VBox::line {selection0 selection1 color } {

	set coordinates0 [[atomselect top "index $selection0"] get {x y z}]
	set coordinates1 [[atomselect top "index $selection1"] get {x y z}]
	
	# Draw line
	draw color $color
	set a [graphics [molinfo top] line "[lindex $coordinates0 0] [lindex $coordinates0 1] [lindex $coordinates0 2]" "[lindex $coordinates1 0] [lindex $coordinates1 1] [lindex $coordinates1 2]" width 5 style dashed]
	
	# Add text
	#set b [graphics 0 text "[lindex $coordinates0 0] [lindex $coordinates0 1] [lindex $coordinates0 2]" "$value Angstroms"]
	
	return  "$a"


}


proc VBox::triangle {selection0 selection1 selection2 color } {
	set coordinates0 [[atomselect top "index $selection0"] get {x y z}]
	set coordinates1 [[atomselect top "index $selection1"] get {x y z}]
	set coordinates2 [[atomselect top "index $selection2"] get {x y z}]

	
	# Draw line
	
	draw color $color
	set a [graphics [molinfo top] triangle "[lindex $coordinates0 0] [lindex $coordinates0 1] [lindex $coordinates0 2]" "[lindex $coordinates1 0] [lindex $coordinates1 1] [lindex $coordinates1 2]" "[lindex $coordinates2 0] [lindex $coordinates2 1] [lindex $coordinates2 2]"]
	
	# Add text
	#set b [graphics [molinfo top] text "[lindex $coordinates1 0] [lindex $coordinates1 1] [lindex $coordinates1 2]" "$value degrees"]
	
	return  "$a"
}


proc VBox::cylinder {selection0 selection1 color} {
	set coordinates0 [[atomselect top "index $selection0"] get {x y z}]
	set coordinates1 [[atomselect top "index $selection1"] get {x y z}]

	# Draw
	
	draw color $color
	set a [graphics [molinfo top] cylinder "[lindex $coordinates0 0] [lindex $coordinates0 1] [lindex $coordinates0 2]" "[lindex $coordinates1 0] [lindex $coordinates1 1] [lindex $coordinates1 2]"  radius 0.2 resolution 50]
	
	# Add graphics that will be deleted
	return  $a
	

}





#### START

proc VBox::vBox {}  {

    # see if the window exists
	if {[winfo exists $VBox::topGui]} {wm deiconify $VBox::topGui ;return $VBox::topGui}

    ## subtitles envoding
    encoding system utf-8

	## Lauch GUI
	VBox::startGui
        display update ui

	## Update VMD display
	display backgroundgradiend on
        display rendermode GLSL

    ## Display introductory message
	VBox::titleshow $VBox::topGui.frame1.c1 $VBox::message

	## Axes off
	axes location off

    ## Add values
    VBox::treeAdd

    ## gets list of item from tree
    VBox::getitems $VBox::topGui.frame1.f.tree 0

	## Select first value
    $VBox::topGui.frame1.f.tree selection set "{[lindex $VBox::treeItems 0]}"


	## Bindings
	wm protocol $VBox::topGui WM_DELETE_WINDOW {after cancel  $VBox::afterID }
	wm protocol $VBox::topGui WM_DELETE_WINDOW { wm withdraw $VBox::topGui; after cancel  $VBox::afterID }

	return $VBox::topGui

}


