package provide selV 1.0

#
# SelectionViewer v1.0
#
# GUI to creatom atom selection in VMD.
#
# (c) 2014 by Nuno M. F. Sousa A. Cerqueira <nscerqueira@gmail.com> or <nscerque@fc.up.pt>
#
###########################################################################################
#
# create package and namespace and default all namespace global variables.

namespace eval selV:: {

    variable version		"1.0"
    variable layers         {} ;# values of the combobox
    variable selection      {}
    variable widget         "tree"
    variable topGui         .selV
    variable entrySel          ""
}



#### START GUI

proc selV::startGui {} {

	#### Check if the window exists
	if {[winfo exists $selV::topGui]} {wm deiconify $selV::topGui; return $selV::topGui}
	toplevel $selV::topGui

	#### Title of the windows
	wm title $selV::topGui "Selection Manager $selV::version " ;# titulo da pagina


    #### Change the location of window
    
    #mainmenu location
    menu main move 0 50

    # screen width and height
    set sWidth  [expr [winfo vrootwidth  $selV::topGui] ]
    set sHeight [expr [winfo vrootheight $selV::topGui] -150]

    #window wifth and height
    set wWidth  [winfo reqwidth $selV::topGui]
    set wHeight [winfo reqheight $selV::topGui]

    display reposition 230 [expr ${sHeight} - 15]
    display resize [expr $sWidth - 550] ${sHeight}

    #wm geometry window $VBox::topGui 40x59 0
    wm geometry $selV::topGui 230x${sHeight}+0+120


    # menu graphics
    menu graphics move $sWidth [expr ${sHeight} - 15]

    #### FRAME 0
    grid [frame $selV::topGui.frame0] -row 0 -column 0 -padx 1 -pady 1 -sticky news
       	grid [ttk::label $selV::topGui.frame0.l1 -text "Molecule:"] -in $selV::topGui.frame0 -row 1 -column 0 -sticky nsew 
        grid [ttk::combobox   $selV::topGui.frame0.cb1 -values $selV::layers -postcommand selV::PDBList ] -in $selV::topGui.frame0 -row 1 -column 1 -sticky ew

	#### FRAME 1 - Paned Window

	grid [ttk::panedwindow $selV::topGui.frame1 -orient vertical] -row 1 -column 0 -padx 2 -pady 1 -sticky news


        # ttk::frame
        $selV::topGui.frame1 add [ttk::frame $selV::topGui.frame1.frame10] -weight 2 

            #frame 1
            grid [ttk::frame $selV::topGui.frame1.frame10.f0] -in $selV::topGui.frame1.frame10 -row 0 -column 0 -sticky news

		    #treeView
		    grid [ttk::treeview $selV::topGui.frame1.frame10.f0.tree -show tree -height 18 -yscroll "$selV::topGui.frame1.frame10.f0.vsb set" ] -in $selV::topGui.frame1.frame10.f0 -row 0 -column 0 -sticky news 
            grid [ttk::scrollbar $selV::topGui.frame1.frame10.f0.vsb -orient vertical -command "$selV::topGui.frame1.frame10.f0.tree yview"] -in $selV::topGui.frame1.frame10.f0 -row 0 -column 1  -sticky ns 
 

            #frame 2
            grid [ttk::frame $selV::topGui.frame1.frame10.f1] -in $selV::topGui.frame1.frame10 -row 1 -column 0 -sticky we 

                # label     
                grid [ttk::label $selV::topGui.frame1.frame10.f1.lb1 -text "Custom:"] -in $selV::topGui.frame1.frame10.f1 -row 0 -column 0 

                # entry
                ttk::style layout entry {
                  Plain.Entry.field -sticky nswe -children {
                      Plain.Entry.padding -sticky nswe -children {
                          Plain.Entry.textarea -sticky nswe
                      }
                  }
                }

                grid [ttk::entry $selV::topGui.frame1.frame10.f1.en1 -style entry -validate all -validatecommand {selV::entrySelection %P 0}] -in $selV::topGui.frame1.frame10.f1 -row 0 -column 1 -sticky ew 


            #button
            grid [ttk::button $selV::topGui.frame1.frame10.f1.bt1 -width 1 -text "?" -command {selV::help}] -in $selV::topGui.frame1.frame10.f1 -row 0 -column 2 



        # frame
        $selV::topGui.frame1 add [ttk::frame $selV::topGui.frame1.frame11] 
            
            # Label
            grid [ttk::label $selV::topGui.frame1.frame11.l1 -text "Selected Items :"] -in $selV::topGui.frame1.frame11 -row 0 -column 0 

		    #LISTBox
		    grid [listbox $selV::topGui.frame1.frame11.lb1  -yscroll "$selV::topGui.frame1.frame11.vsb set" -xscroll "$selV::topGui.frame1.frame11.hsb set"  ]  -in $selV::topGui.frame1.frame11 -row 1 -column 0 -padx 2 -sticky news
            grid [ttk::scrollbar $selV::topGui.frame1.frame11.vsb -orient vertical -command "$selV::topGui.frame1.frame11.lb1 yview"] -in $selV::topGui.frame1.frame11 -row 1 -column 1  -sticky ns 

            grid [ttk::scrollbar $selV::topGui.frame1.frame11.hsb -orient horizontal -command "$selV::topGui.frame1.frame11.lb1 xview"] -in $selV::topGui.frame1.frame11 -row 2 -column 0  -sticky ew 



    #### FRAME 3


	#### FRAME 4
	grid [ttk::frame $selV::topGui.frame4] -row 3 -column 0 -pady 5 -sticky news

		# Button
    
		grid [ttk::button $selV::topGui.frame4.bt1 -text "Add" -width 3 -command {selV::addSelection}] -in $selV::topGui.frame4 -row 0 -column 0 -sticky ew 
        grid [ttk::button $selV::topGui.frame4.bt2 -text "Delete" -width 5 -command {selV::deleteSelection}] -in $selV::topGui.frame4 -row 0 -column 1 
        grid [ttk::button $selV::topGui.frame4.bt3 -text "Edit" -width 3 -command {selV::edit}] -in $selV::topGui.frame4 -row 0 -column 2 
        grid [ttk::button $selV::topGui.frame4.bt4 -text "?" -width 1 -command {selV::about}] -in $selV::topGui.frame4 -row 0 -column 3



   	#### GUI weight
  	grid columnconfigure $selV::topGui                      0 -weight 1
    grid columnconfigure $selV::topGui.frame0               1 -weight 1
    grid columnconfigure $selV::topGui.frame1.frame10       0 -weight 1
    grid columnconfigure $selV::topGui.frame1.frame11       0 -weight 1
    grid columnconfigure $selV::topGui.frame4               0 -weight 1
    grid columnconfigure $selV::topGui.frame1.frame10.f0    0 -weight 1
    grid columnconfigure $selV::topGui.frame1.frame10.f1    1 -weight 1

    grid rowconfigure $selV::topGui                         1 -weight 1
    grid rowconfigure $selV::topGui.frame1.frame10          0 -weight 1
    grid rowconfigure $selV::topGui.frame1.frame10.f0       0 -weight 1

    grid rowconfigure $selV::topGui.frame1.frame11          1 -weight 2
    grid rowconfigure $selV::topGui.frame4                  0 -weight 1



    #### Bindings
    bind $selV::topGui.frame0.cb1 <<ComboboxSelected>> selV::selectPDB
    bind $selV::topGui.frame1.frame10.f0.tree <<TreeviewSelect>> {selV::treeSelectItem 0}
    bind $selV::topGui.frame1.frame11.lb1  <Double-Button-1> { selV::clickListBox double}
    bind $selV::topGui.frame1.frame11.lb1  <<ListboxSelect>> { selV::clickListBox single}


    #### Fill ComboBox with PDBs
    selV::PDBList

    #### Fill tree with Values
    if {$selV::layers!={} } {selV::fillTree}

}

#### HELP GUI
 proc selV::help {} {
        set help $selV::topGui.about
	    if {[winfo exists $help]} {wm deiconify $help ; raise $help; return}
        toplevel $help
        wm title $help "Selections Help"

        grid [text $help.tx -width 40 -bg yellow -height 25 -bg white \
                -yscrollcommand "$help.roll set" \
                -wrap word -cursor top_left_arrow] \
                -row 0 -column 0 -sticky news
        grid [scrollbar $help.roll -width 12 \
                -command "$help.tx yview"] -row 0 -column 1 -sticky news
        grid [button $help.close -text "Close" -borderwidth 6 \
                -command {if {[winfo exists $selV::topGui.about]} {wm withdraw $selV::topGui.about }}] -row 1 -column 0 \
                -columnspan 2 -sticky news
        grid rowconfigure    $help 0 -weight 1
        grid columnconfigure $help 0 -weight 1



set text "VMD has a rather powerful atom selection language available. It is based around the assumption that every atom has a set of associated with it values which can be accessed through keywords. These values could be boolean (is this a protein atom?), numeric (as in the atom index or atomic mass), or string (the atom name).

Here are some basic examples of valid selection commands in VMD.

        all
        waters
        protein
        backbone
        resname GLU
        resid 35
        name CA
        name 'A *'
        mass < 5
        numbonds = 2
        protein sequence \"C..C\"
        protein and @myselection

These keywords can then be combined using the words 'and', 'not' and 'or'. Here are some examples.

        not protein
        all and not waters
        resname GLU and chain A
        protein (backbone or name H)

There are also some special selections such as:
        (C) 
        all within 5 of resid 10
        protein within 5 of nucleic
        same resname as (protein within 5 of nucleic)
        protein and @myselection
"
     $selV::topGui.about.tx insert 1.0 $text


 }


#### GET PDBs loaded

proc selV::PDBList {} {
    # Add items
    set selV::layers ""
    if {[llength [molinfo list]]!=0} {

        # delete old item
        if {$selV::selection!=""} {
            ## modify representation if it already exists
            set repid [mol repindex top $selV::selection] 
            mol delrep $repid top
        }

        foreach mol [molinfo list] {
            set selV::layers [lappend selV::layers "[molinfo $mol get id]: [molinfo $mol get name]"]
        }
        # update comboBox values
        $selV::topGui.frame0.cb1 configure -values $selV::layers

        # Select the toplayer as the value on the comboBox
        $selV::topGui.frame0.cb1 set "[molinfo [molinfo top] get id]: [molinfo [molinfo top] get name]"

        ## fill the data off rep on the lisbbox
        selV::fillListbox
    } else {selV::cleanGui}


}

#### FILL TREE LIST with the protein Data
proc selV::fillTree {} {

    ## Remove tree values
    $selV::topGui.frame1.frame10.f0.tree delete [ $selV::topGui.frame1.frame10.f0.tree  children {}]

    ## How many chain are
    set chains ""
    set sel [atomselect top "all"]
    set data  [$sel get {chain} ]
    $selV::topGui.frame1.frame10.f0.tree insert {} end -id 0 -text "none"

    foreach chain $data {

        if {[lsearch $chains $chain]==-1} {
            ## Selects Chain
            set chains [lappend chains $chain]
            $selV::topGui.frame1.frame10.f0.tree insert {} end -id [llength $chains] -text "chain $chain"

            ## Adds the resname and resid of the protein part
            set sel [atomselect top "(chain $chain and protein)"]
            set residList ""
            set datalist  [$sel get {resname resid residue type} ]
            set id 1
            foreach elem $datalist {
                incr id
                if {[lsearch $residList [lindex $elem 1]]==-1} {
                  if {[llength $residList]==0} {$selV::topGui.frame1.frame10.f0.tree insert [llength $chains] end -id [llength $chains].1 -text "protein"}
                  set residList [lappend residList [lindex $elem 1]]
                  $selV::topGui.frame1.frame10.f0.tree insert [llength $chains].1 end -id [llength $chains].1.$id  -text "[lindex $elem 1] : [lindex $elem 0]"
                  set id2 $id
                }
                  $selV::topGui.frame1.frame10.f0.tree insert [llength $chains].1.$id2 end -id [llength $chains].1.$id2.$id  -text "atom [lindex $elem 3]"

            }

            ## Adds the resname and resid  of non-protein
            set sel [atomselect top "(chain $chain and not protein and not water)"]
            set residList ""
            set datalist  [$sel get {resname resid residue type} ]
            set id 1
            foreach elem $datalist {
                puts $elem
                incr id
                if {[lsearch $residList [lindex $elem 1]]==-1} {
                     if {[llength $residList]==0} {$selV::topGui.frame1.frame10.f0.tree insert [llength $chains] end -id [llength $chains].2 -text "Other"}
                    set residList [lappend residList [lindex $elem 1]]
                    $selV::topGui.frame1.frame10.f0.tree insert [llength $chains].2 end -id [llength $chains].2.$id  -text "[lindex $elem 1] : [lindex $elem 0]"
                    set id2 $id
                }
                    $selV::topGui.frame1.frame10.f0.tree insert [llength $chains].2.$id2 end -id [llength $chains].2.$id2.$id  -text "atom [lindex $elem 3]"


            }

            ## Adds the resname and resid of waters
            set sel [atomselect top "(chain $chain and water)"]
            set residList ""
            set datalist  [$sel get {resname resid residue type} ]
            set id 1
            foreach elem $datalist {
                incr id
                if {[lsearch $residList [lindex $elem 1]]==-1} {
                    if {[llength $residList]==0} {$selV::topGui.frame1.frame10.f0.tree insert [llength $chains] end -id [llength $chains].3 -text "water"}
                    set residList [lappend residList [lindex $elem 1]]
                    $selV::topGui.frame1.frame10.f0.tree insert [llength $chains].3 end -id [llength $chains].3.$id  -text "[lindex $elem 1] : [lindex $elem 0]"
                    set id2 $id
                }
                $selV::topGui.frame1.frame10.f0.tree insert [llength $chains].3.$id2 end -id [llength $chains].3.$id2.$id  -text "atom [lindex $elem 3]"
            }

        }
  }

}
  

proc selV::selectPDB {} {

    ## turn the comboBox PDB the topmolecule
    set selV::selection ""
    foreach mol [molinfo list] {
        set layer [molinfo $mol get name]
        set layersID [molinfo $mol get id]

        if { [lindex [$selV::topGui.frame0.cb1 get] 1]==$layer} {
                ## delete any previous selection representation before the change
                if {$selV::selection!=""} {
                    set repid [mol repindex top $selV::selection] 
                    mol delrep $repid top
                }
            mol top $layersID
            break
        }

    }


    ## fill the data on the tree
    selV::fillTree 

    ## fill the data off rep on the lisbbox
    selV::fillListbox

    ## reset view
    display resetview
}


proc selV::addSelection {} {

    if {[llength [molinfo list]]!=0 && $selV::selection!=""} {

        if {$selV::widget=="tree"} {
            # tree selecttion 
            selV::treeSelectItem 1
            mol color colorid 4
            set selV::selection ""
            selV::fillListbox 
        } else {
            if {$selV::entrySel!="none"} {
                selV::entrySelection $selV::entrySel 1
                mol color colorid 4
                set selV::selection ""
                selV::fillListbox 
            }
           
        }

    } 

}

proc selV::deleteSelection {} {

    ## get item
    set item [$selV::topGui.frame1.frame11.lb1 curselection]
    #set text [$selV::topGui.frame1.frame11.lb1 get $item]
    if {$item!=""} {
        mol  delrep $item top
        selV::fillListbox
    }
    $selV::topGui.frame1.frame11.lb1 selection set [expr $item -1]

}

proc selV::string_diff {str1 str2} {
    for {set i 0} {$i < [string length $str1]} {incr i} {
        if {[string index $str2 $i] ne [string index $str1 $i]} {
            return [string range $str2 $i end]
        }
    }
    return [string range $str2 $i end]
}


proc selV::treeSelectItem {opt} {


    if {[llength [molinfo list]]!=0} {

        set selV::widget tree

        ## generate selection
        set items  [$selV::topGui.frame1.frame10.f0.tree selection]
        set selectionTotal ""
        foreach item $items {

            set selection ""

            while {$item!=""} {
                set textItem [$selV::topGui.frame1.frame10.f0.tree item $item -text]

                ## exception to name items
                if {[llength $textItem]==3} {set textItem "resid [lindex $textItem 0]"}
                if {[lindex $textItem 0]=="atom"} {set textItem "type [lindex $textItem 1]"}
                if {$textItem=="Other"} {set textItem "not protein and not water"}

                ## make small algorithm to decrease the size of the selection


                ## Normal
                if {[llength $selection]!=0} { set selection "$textItem and $selection"
                } else {set selection "$textItem $selection"}
                set item [$selV::topGui.frame1.frame10.f0.tree parent $item ] 
            }

            if {[llength $selectionTotal]==0} { set selectionTotal "($selection)"
            } else {set selectionTotal "$selectionTotal or ($selection)"}
        }

    selV::changeRepresentation $selectionTotal $opt

    } else {selV::cleanGui}

}

proc selV::changeRepresentation {selectionTotal opt} {

    ## Change representation

    # delete old item
    if {$selV::selection!=""} {
        ## modify representation if it already exists
        set repid [mol repindex top $selV::selection] 
        mol delrep $repid top
    }

    # create a new rep
    set atomNum [[atomselect top $selectionTotal] num ]

    mol selection $selectionTotal

    # Change atom representation based on the number of atoms in the selection
    set atomNum [[atomselect top $selectionTotal] num ]

    if {$atomNum>1000} { mol representation cartoon
    } elseif {$atomNum<4} {mol representation VDW
    } else {mol representation Licorice 0.300000 8.000000 6.000000}

    # change color if is selection or add selection
    if {$opt==1} { mol color name
    } else {mol color colorid 4}

    mol addrep top

    # memorize rep details
    set repid [expr [molinfo top get numreps] - 1]
    set repname [mol repname top $repid]
    set selV::selection $repname
}



proc selV::fillListbox {} {
    ## clean listbox
     $selV::topGui.frame1.frame11.lb1 delete 0 [ $selV::topGui.frame1.frame11.lb1 size]
    
    ## Add items
    set repname ""
    for {set i 0} {$i < [molinfo top get numreps]} {incr i} {
        lassign [molinfo top get "{rep $i} {selection $i} "] a b 

        ## all but not the one equal to the one of the selections
        set repid [expr [molinfo top get numreps] -1]
        set repname [mol repname top $i]
        if {$repname!=$selV::selection} {
            
            $selV::topGui.frame1.frame11.lb1 insert end " $b"
            if {[mol showrep top $i]==0} {$selV::topGui.frame1.frame11.lb1 itemconfigure $i -foreground red} else {$selV::topGui.frame1.frame11.lb1 itemconfigure $i -foreground black}
        }

    }

}

proc selV::clickListBox {opt} {


    if {[llength [molinfo list]]!=0} {


        ## get item
        set item [$selV::topGui.frame1.frame11.lb1 curselection]
        set text [$selV::topGui.frame1.frame11.lb1 get $item]

        #ver se o numero de items da listabox não é menor do que o numero de items

        if {$item<=[expr [molinfo top get numreps]-1] } {
            $selV::topGui.frame1.frame11.lb1 selection set $item 
        } else { selV::fillListbox; set item [expr [molinfo top get numreps]-1] }

        if {$opt=="double"} {
            if {[mol showrep top $item]==0} {
                mol showrep top $item 1
                $selV::topGui.frame1.frame11.lb1 itemconfigure $item -foreground black
                $selV::topGui.frame1.frame11.lb1 itemconfigure $item -selectforeground black
            } else {
                mol showrep top $item 0
                $selV::topGui.frame1.frame11.lb1 itemconfigure $item -foreground red  
                $selV::topGui.frame1.frame11.lb1 itemconfigure $item -selectforeground red
            }

        } else {

            if {[mol showrep top $item]==1} {
                $selV::topGui.frame1.frame11.lb1 itemconfigure $item -selectforeground black
            } else {
                $selV::topGui.frame1.frame11.lb1 itemconfigure $item -selectforeground red
            }

            $selV::topGui.frame1.frame11.lb1 selection set $item 

            # select item no rep
            # modselect rep_number molecule_number select_method
        }

        # See item that was selected
        $selV::topGui.frame1.frame11.lb1 see $item

    } else {selV::cleanGui}
}

proc selV::edit {} {
    set item [$selV::topGui.frame1.frame11.lb1 curselection]
    if {$item!=""} {
           if {[menu graphics status]=="off"} {menu graphics on}
    }


}

proc selV::entrySelection {selection opt} {
    set error ""
    if {$selV::layers!={}} {
        catch {set error [atomselect top "$selection"]} atomselect
        ## see if the text give error or not
    
        if {$error==""} {
            #turn widget red
            ttk::style configure entry -foreground red  -borderwidth 2 -padding 0
            #set selV::selection ""
            selV::changeRepresentation "none" 0
            set selV::entrySel "none"


        } else {
            ttk::style configure entry -foreground black  -borderwidth 2 -padding 0
            ## put the selection in yellow
            set selV::entrySel $selection
            selV::changeRepresentation $selection $opt
        }

        ## avaliate the text
        # if there is not error turn it in yellow
        # otherwise turn the text red
        set selV::widget entry
    }
        return 1

}
proc selV::about {} {
    tk_messageBox -icon info -title Help -parent $selV::topGui -type ok -message "Selection Viewer provides an easy GUI to handle molecule selections.\n\nContact: \nNuno Sousa Cerqueira (nscerque@fc.up.pt) \nFaculty of Sciences - University of Porto - Portugal" 
}


proc selV::cleanGui {} {
    $selV::topGui.frame1.frame10.f0.tree delete [ $selV::topGui.frame1.frame10.f0.tree  children {}]
    $selV::topGui.frame1.frame11.lb1 delete 0 end
    set  $selV::layers ""
    $selV::topGui.frame0.cb1 configure -values $selV::layers
    $selV::topGui.frame0.cb1 set ""
}

proc selV::start {} {
    if {[winfo exists $selV::topGui]} {wm deiconify $selV::topGui ; raise $selV::topGui; return $selV::topGui}

    ##### START GUI
    selV::startGui
   	return $selV::topGui
}

